#include <p30fxxxx.h>
#include <timer.h>

/* These devices support Timer 5 */
#if defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || defined(__dsPIC30F3011__)  || \
    defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || \
    defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F4013__) || \
    defined(__dsPIC30F5015__)

/********************************************************************
*    Function Name:  CloseTimer5                                    *
*    Description:    This routine disables the Timer5 and its       *
*                    interrupt and flag bits.                       *
*    Parameters:     None                                           *
*    Return Value:   None                                           *
********************************************************************/

void CloseTimer5(void)
{
    IEC1bits.T5IE = 0;  /* Disable the Timer5 interrupt */
    T5CONbits.TON=0;    /* disable Timer 5 */
    IFS1bits.T5IF = 0;  /* Clear Timer5 interrupt flag */
}

#endif 
